; -----------------------------------------------------------------------------------------
; EEPROM-Werte fr eine Beispielkonfiguration aus der Praxis zur Anzeige von 4 Sensorwerten
; -----------------------------------------------------------------------------------------
;
.eseg
;
;  --------------------------
; | Position 1    Position 5 |	Die Sensor-Tabelle enthlt die 8 Sensornummern (im Bereich 1-31) in der Reihenfolge, wie sie auf dem Display angezeigt werden sollen. Anzeigepositionen, die nicht
; | Position 2    Position 6 |	genutzt werden, mssen eine 0 enthalten. Sind die letzten 4 Sensornummern auf 0 gesetzt, dann arbeitet das Anzeigemodul im 4-Sensor-Modus mit verlngerten Sensornamen.
; | Position 3    Position 7 |
; | Position 4    Position 8 |	Das nebenstehende Bild zeigt die 8 Anzeigepositionen.
;  --------------------------
;
esentb:	.db	1			;Anzeigeposition 1: Sensornummer 1 (Temperatur)
	.db	29			;Anzeigeposition 2: Sensornummer 29 (Luftfeuchtigkeit)
	.db	2			;Anzeigeposition 3: Sensornummer 2 (Temperatur)
	.db	28			;Anzeigeposition 4: Sensornummer 28 (Luftdruck)
	.db	0			;Anzeigeposition 5: nicht genutzt \
	.db	0			;Anzeigeposition 6: nicht genutzt  \ Diese Einstellung bewirkt die Umschaltung
	.db	0			;Anzeigeposition 7: nicht genutzt  / des Anzeigemoduls in den 4-Sensor-Modus
	.db	0			;Anzeigeposition 8: nicht genutzt /
;
; ber die folgende Liste kann fr Temperatursensoren ein unteres Temperaturlimit eingestellt werden, bei Unterschreitung des Limits blinkt ein Symbol hinter dem Wert und ein Alarm wird ausgelst.
; Alle Werte mssen in Grad Celsius angegeben werden, auch negative Werte sind mglich. Ein Wert von 128 schaltet die Alarmberwachung aus. Die Reihenfolge entspricht der Anzeigeposition 1-8:
;
elim_l:	.db	15			;Unteres Temperaturlimit fr Anzeigeposition 1 (Alarm, wenn Temperatur < 15C)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 2 (kein Alarm bei Luftfeuchtigkeit mglich)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 3 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 4 (kein Alarm bei Luftdruck mglich)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 5 (nicht genutzt)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 6 (nicht genutzt)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 7 (nicht genutzt)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 8 (nicht genutzt)
;
; ber die folgende Liste kann fr Temperatursensoren ein oberes Temperaturlimit eingestellt werden, bei berschreitung des Limits blinkt ein Symbol hinter dem Wert und ein Alarm wird ausgelst.
; Alle Werte mssen in Grad Celsius angegeben werden, auch negative Werte sind mglich. Ein Wert von 128 schaltet die Alarmberwachung aus. Die Reihenfolge entspricht der Anzeigeposition 1-8:
;
elim_h:	.db	35			;Oberes Temperaturlimit fr Anzeigeposition 1 (Alarm, wenn Temperatur > 35C)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 2 (kein Alarm bei Luftfeuchtigkeit mglich)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 3 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 4 (kein Alarm bei Luftdruck mglich)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 5 (nicht genutzt)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 6 (nicht genutzt)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 7 (nicht genutzt)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 8 (nicht genutzt)
;
; Hier knnen die Sensornamen festgelegt werden. Wird das Anzeigemodul im 8-Sensor-Modus verwendet, dann gelangen nur die ersten 4 Zeichen auf die Anzeige. Im 4-Sensor-Modus werden alle 14 Zeichen
; genutzt, allerdings nur bei den Zeilen 1-4. Diese Struktur verschwendet zwar Speicherplatz, vereinfacht aber die Programmierung. Umlaute mssen entsprechend des LCD-Zeichensatzes kodiert werden:
; = 0xe1, = 0xef, = 0xf5, = 0xe2 (gilt fr die meisten LCD mit HD44780, im Zweifelsfall bitte im Datenblatt nachschauen)
;
esentx:	.db	"Wohnzimmer    "		;"Wohnzimmer"     Display-Text fr Anzeigeposition 1 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"Wohnzimmer    "		;"Wohnzimmer"     Display-Text fr Anzeigeposition 2 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"Au", 0xe2, "entemperat."	;"Auentemperat." Display-Text fr Anzeigeposition 3 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"Luftdruck     "		;"Luftdruck"      Display-Text fr Anzeigeposition 4 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"              "		;Display-Text fr Anzeigeposition 5 (ungenutzt, muss aber 14 Zeichen enthalten)
	.db	"              "		;Display-Text fr Anzeigeposition 6 (ungenutzt, muss aber 14 Zeichen enthalten)
	.db	"              "		;Display-Text fr Anzeigeposition 7 (ungenutzt, muss aber 14 Zeichen enthalten)
	.db	"              "		;Display-Text fr Anzeigeposition 8 (ungenutzt, muss aber 14 Zeichen enthalten)
;
; In der Alarm-Invertierungs-Tabelle wird festgelegt, wie die Alarmmeldungen auszuwerten sind: 0 = normal, 1 = invertiert. Bei einem Arbeitskontakt am Sensormodul ist hier 0 und bei einem Ruhekontakt
; 1 einzutragen:
;
ealmin:	.db	1			;Invertierung fr Alarm 1 (Alarm-Kontakt geschlossen)
	.db	0			;Invertierung fr Alarm 2 (Alarm-Kontakt geffnet)
	.db	1			;Invertierung fr Alarm 3 (Alarm-Kontakt geschlossen)
	.db	1			;Invertierung fr Alarm 4 (Alarm-Kontakt geschlossen)
;
; Hier knnen die Alarmnamen festgelegt werden (4 Texte mit je 12 Zeichen). Werden weniger als 12 Zeichen verwendet, dann ist der Name mit Leerzeichen aufzufllen:
;
ealmtx:	.db	"Garagentor  "		;Display-Text bei Alarm 1 (12 Zeichen)
	.db	"ungenutzt   "		;Display-Text bei Alarm 2 (12 Zeichen)
	.db	"Briefkasten "		;Display-Text bei Alarm 3 (12 Zeichen)
	.db	"Dachfenster "		;Display-Text bei Alarm 4 (12 Zeichen)
;
eprsth:	.db	4			;Schwellwert fr Luftdruck-Tendenz-Anzeige, ab dem hier eingestellten Differenzwert wird eine fallende oder steigende Tendenz angezeigt (Wertebereich 2-9)
;
epoint:	.db	7			;selbst definiertes Zeichen (Komma) zwischen Einer und Zehntel bei Temperaturwerten (alternativ jedes ASCII-Zeichen ab 0x20 mglich, z.B. '.' oder ',')
;
